<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserStudent extends Model 
{

    protected $table = 'user_student';
    public $timestamps = true;

    public function childrens()
    {
        return $this->hasOne('UserStudentChildren');
    }

    public function bookings()
    {
        return $this->belongsTo('Booking', 'booking_id');
    }

    public function settings()
    {
        return $this->belongsTo('UserStudentSettings', 'user_id');
    }

}